/**
 * 
 */
package gov.va.genisis2.service;

import java.util.List;

import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.RefreshHistory;
import gov.va.genisis2.model.StudyApproval;

/**
 * @author 586338
 *
 */
public interface IStudyApprovalService {
	public int createStudyApproval(StudyApproval studyApproval) throws GenisisServiceException;

	public int updateStudyApproval(StudyApproval studyApproval) throws GenisisServiceException;

	public StudyApproval getStudyApprovalsByID(int id) throws GenisisServiceException;

	public List<StudyApproval> getStudyApprovalsByUID(String uid) throws GenisisServiceException;

	public List<StudyApproval> getStudyApprovals() throws GenisisServiceException;

	public void refreshStudyApproval() throws GenisisServiceException;

	public RefreshHistory updateStudyApprovalRefreshHistory(RefreshHistory refreshHistory) throws GenisisServiceException;

	public List<StudyApproval> getStudyApprovalsByTitle(String title) throws GenisisServiceException;

}
